/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package javareading;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

/**
 *
 * @author stone
 */
public class UDPReceiver implements Runnable {
    private MulticastSocket socket;
    
    public UDPReceiver(InetAddress multicastAddress, int port) {
        try {
            this.socket = new MulticastSocket(port);
        } catch (IOException ex) {
            System.out.println("MulticastSocketの作成時にIOExceptionが発生しました。");
            System.exit(1);
        }
        try {
            socket.joinGroup(multicastAddress);
        } catch (IOException ex) {
            ex.printStackTrace();
            System.out.println("joinGroupの実行中にIOExceptionが発生しました。");
            System.exit(2);
        }
    }
    
    public void run() {
        System.out.println("UDPReceiverを起動します。");
        
        for (;;) {
            byte[] buffer = new byte[1000];
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                socket.receive(packet);
            } catch (IOException ex) {
                System.out.println("受信時にIOExceptionが発生しました。");
                return;
            }
            new ConnectionHandler(packet).run();
        }
    }

}
